IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[P_TRILHO_RODA_TRILHO_EXEC_ALL]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [P_TRILHO_RODA_TRILHO_EXEC_ALL]
GO

CREATE PROCEDURE [P_TRILHO_RODA_TRILHO_EXEC_ALL]
as
DECLARE @CD_EMP INT , @CD_CTR INT;
DECLARE cDepo CURSOR FAST_FORWARD FOR 

	SELECT DISTINCT V.CD_EMP, V.CD_CTR_DEPO
	 FROM 
		V_PRC_FILIAL_RELACAO_DEPOSITOS V
		INNER JOIN PRC_FILIAL_DEPOSITO D ON D.CD_CTR_DEPO = V.CD_CTR_DEPO
	WHERE D.FLAG_DESATIVADO = 0 /*Somente depósitos ativos*/

OPEN cDepo
FETCH NEXT FROM cDepo INTO @CD_EMP, @CD_CTR
WHILE @@FETCH_STATUS=0
	  begin
		Print 'Executando os trilhos do deposito ' + convert(varchar(10), @CD_CTR) + ' - ' + CONVERT(VARCHAR, GETDATE (),108);
		EXEC dbo.P_TRILHO_RODA_TRILHO @CD_EMP, @CD_CTR
		FETCH NEXT FROM cDepo INTO @CD_EMP, @CD_CTR
	  end
PRINT 'Concluido.'
CLOSE cDepo;
DEALLOCATE cDepo;
